function Html-ToText {
param([System.String] $html)

# remove line breaks, replace with spaces
$html = $html -replace "(`r|`n|`t)", " "
# write-verbose "removed line breaks: `n`n$html`n"

# remove invisible content
@('head', 'style', 'script', 'object', 'embed', 'applet', 'noframes', 'noscript', 'noembed') | % {
$html = $html -replace "<$_[^>]*?>.*?</$_>", ""
}
# write-verbose "removed invisible blocks: `n`n$html`n"

# Condense extra whitespace
$html = $html -replace "( )+", " "
# write-verbose "condensed whitespace: `n`n$html`n"

# Add line breaks
@('div','p','blockquote','h[1-9]') | % { $html = $html -replace "</?$_[^>]*?>.*?</$_>", ("`n" + '$0' )}
# Add line breaks for self-closing tags
@('div','p','blockquote','h[1-9]','br') | % { $html = $html -replace "<$_[^>]*?/>", ('$0' + "`n")}
# write-verbose "added line breaks: `n`n$html`n"

#strip tags
$html = $html -replace "<[^>]*?>", ""
# write-verbose "removed tags: `n`n$html`n"

# replace common entities
@(
@("&amp;bull;", " * "),
@("&amp;lsaquo;", "<"),
@("&amp;rsaquo;", ">"),
@("&amp;(rsquo|lsquo);", "'"),
@("&amp;(quot|ldquo|rdquo);", '"'),
@("&amp;trade;", "(tm)"),
@("&amp;frasl;", "/"),
@("&amp;(quot|#34|#034|#x22);", '"'),
@('&amp;(amp|#38|#038|#x26);', "&amp;"),
@("&amp;(lt|#60|#060|#x3c);", "<"),
@("&amp;(gt|#62|#062|#x3e);", ">"),
@('&amp;(copy|#169);', "(c)"),
@("&amp;(reg|#174);", "(r)"),
@("&amp;nbsp;", " "),
@("&amp;(.{2,6});", "")
) | % { $html = $html -replace $_[0], $_[1] }
# write-verbose "replaced entities: `n`n$html`n"

return $html

}

#Custom variables
$CompanyName = 'CONTOSO'
$DomainName = 'contoso.local'

#When the version number are updated the local signature are re-created. The value of this variable will be stored in appropriate registry value and every log on compared to it
$SigVersion = '1.7'
$SigSource = "\\contoso.local\NETLOGON\Firma\"

#When set to 1 the signature is enforced as default signature for new messages. 0 = no force, 1 = force
$ForceSignatureNew = '1'

#When set to 1 the signature is enforced as default signature for reply/forward messages. 0 = no force, 1 = force
$ForceSignatureReplyForward = '0'

#Environment variables
$AppData=(Get-Item env:appdata).value
$SigPath = '\Microsoft\Signatures'
$LocalSignaturePath = $AppData+$SigPath

#Get Active Directory information for current user
$UserName = $env:username
$Filter = "(&(objectCategory=User)(samAccountName=$UserName))"
$Searcher = New-Object System.DirectoryServices.DirectorySearcher
$Searcher.Filter = $Filter
$ADUserPath = $Searcher.FindOne()
$ADUser = $ADUserPath.GetDirectoryEntry()
$ADDisplayName = $ADUser.DisplayName
$ADMail = $ADUser.Mail
$ADTitle = $ADUser.Title
$ADCompany = $ADUser.Company
$ADDepartment = $ADUser.Department
$ADStreetAddress = $ADUser.StreetAddress
$ADCity = $ADUser.l
$ADTelePhoneNumber = $ADUser.TelephoneNumber
$ADCellNumber = $ADUser.Mobile
$ADsamaccountname = $ADUser.samaccountname
$ADwww = $ADUser.wwwHomePage
$ViaAzienda = $ADUser.streetAddress
$PiePagina = $ADUser.info
$ADInternoDiretto = $ADUser.homePhone

$ADOtherMailbox = $ADUser.otherMailbox
$ADOtherMailboxArray = @($ADUser.otherMailbox) #Creo l'array per altri indirizzi mail nell'attributo Active Directory "OtherMailbox"                           

$OtherMailbox1 = $ADOtherMailboxArray[0] #Associo le righe degli altri indirizzi email ad un array
$OtherMailbox2 = $ADOtherMailboxArray[1]
$OtherMailbox3 = $ADOtherMailboxArray[2]

write-host $ADDisplayName
write-host $ADTitle
write-host $ADMail
write-host $ADCompany
write-host $ADDepartment
write-host $ADStreetAddress
write-host $ADCity
write-host $ADTelePhoneNumber 
write-host $ADCellNumber
write-host $ViaAzienda
write-host $PiePagina
write-host $ADInternoDiretto
write-host $ADOtherMailbox

#Setting registry information for the current user.
#Putting a new key with company name to the registry and creating signature settings there
$CompanyRegPath = "HKCU:\Software\"+$CompanyName
if (Test-Path $CompanyRegPath){}
else {New-Item -path "HKCU:\Software" -name $CompanyName}
if (Test-Path $CompanyRegPath'\Outlook Signature Settings'){}
else {New-Item -path $CompanyRegPath -name "Outlook Signature Settings"}
$ForcedSignatureNew = (Get-ItemProperty $CompanyRegPath'\Outlook Signature Settings').ForcedSignatureNew
$ForcedSignatureReplyForward = (Get-ItemProperty $CompanyRegPath'\Outlook Signature Settings').ForcedSignatureReplyForward
$SignatureVersion = (Get-ItemProperty $CompanyRegPath'\Outlook Signature Settings').SignatureVersion
Set-ItemProperty $CompanyRegPath'\Outlook Signature Settings' -name SignatureSourceFiles -Value $SigSource
$SignatureSourceFiles = (Get-ItemProperty $CompanyRegPath'\Outlook Signature Settings').SignatureSourceFiles


 $firma = Get-Content "$SigSource\modello.html"
 if (-not ([string]::IsNullOrEmpty($firma))) {
 
		 $firma = $firma -replace "%DisplayName%",$ADDisplayName
         $firma = $firma -replace "%Email%",$ADMail
         $firma = $firma -replace "%Department%",$ADDepartment
		 $firma = $firma -replace "%Title%",$ADTitle
		 $firma = $firma -replace "%Company%",$ADCompany
		 $firma = $firma -replace "%ViaAzienda%",$ViaAzienda
		 $firma = $firma -replace "%PiePagina%",$PiePagina
         $firma = $firma -replace "%Sito%","$ADwww";

		 if ($ADTelePhoneNumber -ne "") {
			$firma = $firma -replace "%TelephoneNumber%","M +39 $ADTelePhoneNumber <br>";
			}
		  else {
			$firma = $firma -replace "%TelephoneNumber%","<br>";
			}
		 
		 $firma | out-file "$LocalSignaturePath\($ADMail).htm"

        
    
 if (-not ([string]::IsNullOrEmpty($ADOtherMailboxArray[0]))) {     #Se l'attributo OtherMailbox ARRAY0 non  vuoto
 echo OtherMailbox ARRAY0 presente
     
    
     $firma = Get-Content "$SigSource\modello.html"
 if (-not ([string]::IsNullOrEmpty($firma))) {
 
		 
		 
		 $firma = $firma -replace "%DisplayName%",$ADDisplayName
         $firma = $firma -replace "%Email%",$ADOtherMailboxArray[0]
         $firma = $firma -replace "%Department%",$ADDepartment
		 $firma = $firma -replace "%Title%",$ADTitle
		 $firma = $firma -replace "%Company%",$ADCompany
		 $firma = $firma -replace "%ViaAzienda%",$ViaAzienda
		 $firma = $firma -replace "%PiePagina%",$PiePagina
         $firma = $firma -replace "%Sito%","$ADwww";


		 if ($ADTelePhoneNumber -ne "") {
			$firma = $firma -replace "%TelephoneNumber%","M +39 $ADTelePhoneNumber <br>";
			}
		else {
			$firma = $firma -replace "%TelephoneNumber%","<br>";
			}	 
		 

		 $firma | out-file "$LocalSignaturePath\($OtherMailbox1).htm"
    
    
    }
    }
    
 if (-not ([string]::IsNullOrEmpty($ADOtherMailboxArray[1]))) {     #Se l'attributo OtherMailbox ARRAY1 non  vuoto
 echo OtherMailbox ARRAY1 presente
     
    
     $firma = Get-Content "$SigSource\modello.html"
 if (-not ([string]::IsNullOrEmpty($firma))) {
		 
		 
		 $firma = $firma -replace "%DisplayName%",$ADDisplayName
         $firma = $firma -replace "%Email%",$ADOtherMailboxArray[1]
         $firma = $firma -replace "%Department%",$ADDepartment
		 $firma = $firma -replace "%Title%",$ADTitle
		 $firma = $firma -replace "%Company%",$ADCompany
		 $firma = $firma -replace "%ViaAzienda%",$ViaAzienda
		 $firma = $firma -replace "%PiePagina%",$PiePagina
         $firma = $firma -replace "%Sito%","$ADwww";


		 if ($ADTelePhoneNumber -ne "") {
			$firma = $firma -replace "%TelephoneNumber%","M +39 $ADTelePhoneNumber <br>";
			}
		else {
			$firma = $firma -replace "%TelephoneNumber%","<br>";
			}


		 $firma | out-file "$LocalSignaturePath\($OtherMailbox2).htm"
    
    
    }
    }   

 if (-not ([string]::IsNullOrEmpty($ADOtherMailboxArray[2]))) {     #Se l'attributo OtherMailbox ARRAY2 non  vuoto
 echo OtherMailbox ARRAY2 presente
     
    
     $firma = Get-Content "$SigSource\modello.html"
 if (-not ([string]::IsNullOrEmpty($firma))) {
		 
		 
		 $firma = $firma -replace "%DisplayName%",$ADDisplayName
         $firma = $firma -replace "%Email%",$ADOtherMailboxArray[2]
         $firma = $firma -replace "%Department%",$ADDepartment
		 $firma = $firma -replace "%Title%",$ADTitle
		 $firma = $firma -replace "%Company%",$ADCompany
		 $firma = $firma -replace "%ViaAzienda%",$ViaAzienda
		 $firma = $firma -replace "%PiePagina%",$PiePagina
         $firma = $firma -replace "%Sito%","$ADwww";


		 if ($ADTelePhoneNumber -ne "") {
			$firma = $firma -replace "%TelephoneNumber%","M +39 $ADTelePhoneNumber <br>";
			}
		else {
			$firma = $firma -replace "%TelephoneNumber%","<br>";
			}
	 

		 $firma | out-file "$LocalSignaturePath\($OtherMailbox3).htm"
    
    
    }
    }
    
         

		#Stamp registry-values for Outlook Signature Settings if they doesn`t match the initial script variables.
		#Note that these will apply after the second script run when changes are made in the "Custom variables"-section.
		if ($ForcedSignatureNew -eq $ForceSignatureNew){}
		else {Set-ItemProperty $CompanyRegPath'\Outlook Signature Settings' -name ForcedSignatureNew -Value $ForceSignatureNew}
		if ($ForcedSignatureReplyForward -eq $ForceSignatureReplyForward){}
		else {Set-ItemProperty $CompanyRegPath'\Outlook Signature Settings' -name ForcedSignatureReplyForward -Value $ForceSignatureReplyForward}
		if ($SignatureVersion -eq $SigVersion){}
		else {Set-ItemProperty $CompanyRegPath'\Outlook Signature Settings' -name SignatureVersion -Value $SigVersion}
		
 }
